const express = require("express");
const router = express.Router();
const studyGoalController = require("../controllers/studyGoalController");

// Create a new study goal
router.post("/", studyGoalController.createStudyGoal);

// Get all study goals with programs
router.get("/", studyGoalController.getStudyGoals);

// Add program to a study goal
router.post("/:studyGoalId/programs", studyGoalController.addProgramToGoal);

router.delete("/:id", studyGoalController.deleteStudyGoal);

// Add other routes for update, delete, etc.

module.exports = router;
