const express = require("express");
const router = express.Router();
const db = require("../../models");

// GET all important dates
router.get("/", async (req, res) => {
  try {
    const importantDates = await db.ImportantDate.findAll({
      attributes: [
        "id",
        "ap_datefrom",
        "ap_dateto",
        "admitcard",
        "examdate",
        "examstarttime",
        "examendtime",
        "result",
      ],
      order: [["examdate", "DESC"]],
    });

    res.json({
      success: true,
      data: importantDates || [],
    });
  } catch (err) {
    console.error("Error:", err);
    res.status(500).json({
      success: false,
      error: "Failed to fetch data",
      data: [],
    });
  }
});

// POST create new date
router.post("/", async (req, res) => {
  try {
    const requiredFields = [
      "applicationDateFrom",
      "applicationDateTo",
      "admitCardDate",
      "examDate",
      "examTimeFrom",
      "examTimeTo",
      "resultDate",
    ];

    const missingFields = requiredFields.filter((field) => !req.body[field]);
    if (missingFields.length > 0) {
      return res.status(400).json({
        success: false,
        error: "Missing required fields",
        missingFields,
      });
    }

    const newDate = await db.ImportantDate.create({
      ap_datefrom: req.body.applicationDateFrom,
      ap_dateto: req.body.applicationDateTo,
      admitcard: req.body.admitCardDate,
      examdate: req.body.examDate,
      examstarttime: req.body.examTimeFrom,
      examendtime: req.body.examTimeTo,
      result: req.body.resultDate,
    });

    res.status(201).json({
      success: true,
      data: newDate,
    });
  } catch (err) {
    console.error("Error:", err);
    res.status(500).json({
      success: false,
      error: "Failed to create record",
    });
  }
});

// PUT update date
router.put("/:id", async (req, res) => {
  try {
    const date = await db.ImportantDate.findByPk(req.params.id);
    if (!date) {
      return res.status(404).json({
        success: false,
        error: "Record not found",
      });
    }

    await date.update({
      ap_datefrom: req.body.applicationDateFrom || date.ap_datefrom,
      ap_dateto: req.body.applicationDateTo || date.ap_dateto,
      admitcard: req.body.admitCardDate || date.admitcard,
      examdate: req.body.examDate || date.examdate,
      examstarttime: req.body.examTimeFrom || date.examstarttime,
      examendtime: req.body.examTimeTo || date.examendtime,
      result: req.body.resultDate || date.result,
    });

    res.json({
      success: true,
      data: date,
    });
  } catch (err) {
    console.error("Error:", err);
    res.status(500).json({
      success: false,
      error: "Failed to update record",
    });
  }
});

// DELETE date
router.delete("/:id", async (req, res) => {
  try {
    const deleted = await db.ImportantDate.destroy({
      where: { id: req.params.id },
    });

    if (!deleted) {
      return res.status(404).json({
        success: false,
        error: "Record not found",
      });
    }

    res.json({
      success: true,
      message: "Record deleted successfully",
    });
  } catch (err) {
    console.error("Error:", err);
    res.status(500).json({
      success: false,
      error: "Failed to delete record",
    });
  }
});

module.exports = router;
