// model

module.exports = (sequilize, DataTypes) => {
  return sequilize.define(
    "LandingPage",
    {
      college_id: {
        type: DataTypes.INTEGER,
        allowNull: false, // or true if optional
        defaultValue: 1,
      },
      college_url: {
        type: DataTypes.STRING(255),
        defaultValue: "",
      },
      college_logo: { type: DataTypes.STRING(255), defaultValue: "" },
      college_banner: { type: DataTypes.STRING(500), defaultValue: "" },
      title_1: { type: DataTypes.STRING(255), defaultValue: "" },
      description_1: { type: DataTypes.TEXT, defaultValue: "" },
      title_2: { type: DataTypes.STRING(255), defaultValue: "" },
      description_2: { type: DataTypes.TEXT, defaultValue: "" },
      companies: { type: DataTypes.STRING(255), defaultValue: "" },
      datetime: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    },
    {
      tableName: "landing_pages",
      timestamps: false,
      freezeTableName: true,
    }
  );
};
