module.exports = (sequelize, DataTypes) => {
  const College = sequelize.define(
    "College",
    {
      college_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      fk_group_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      college_url: {
        type: DataTypes.STRING(255),
        defaultValue: "",
      },
      alt_tag: {
        type: DataTypes.STRING(255),
        defaultValue: "",
      },
      college_name: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      other_name: {
        type: DataTypes.STRING(30),
        defaultValue: "",
        allowNull: false,
      },
      other_name1: {
        type: DataTypes.STRING(40),
        defaultValue: "",
        allowNull: false,
      },
      city_name: {
        type: DataTypes.STRING(40),
        defaultValue: "",
        allowNull: false,
      },
      placement: {
        type: DataTypes.STRING(30),
        defaultValue: "",
        allowNull: false,
      },
      college_address: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      college_website: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      fk_city_id: {
        type: DataTypes.INTEGER,
        defaultValue: 0,
      },
      fk_indiacity_id: {
        type: DataTypes.INTEGER,
        defaultValue: 0,
      },
      college_city_name: {
        type: DataTypes.STRING(250),
        defaultValue: "",
      },
      fk_state_id: {
        type: DataTypes.INTEGER,
        defaultValue: 0,
      },
      college_state_name: {
        type: DataTypes.STRING(250),
        defaultValue: "",
      },
      fk_country_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      username: {
        type: DataTypes.STRING(500),
        defaultValue: "",
      },
      contact_person: {
        type: DataTypes.STRING(500),
        defaultValue: "",
      },
      is_checkout: {
        type: DataTypes.INTEGER,
        defaultValue: 0,
      },
      password: {
        type: DataTypes.STRING(500),
        defaultValue: "",
      },
      display_name: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      cover_image_id: {
        type: DataTypes.INTEGER,
        defaultValue: 0,
      },
      logo_image_url: {
        type: DataTypes.STRING(1000),
        defaultValue: "",
        get() {
          const rawValue = this.getDataValue("logo_image_url");
          if (!rawValue) return null;
          return `${
            process.env.BASE_URL || "http://localhost:5000"
          }/uploads/${rawValue}`;
        },
      },
      college_usp: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      form_open_date: {
        type: DataTypes.DATE,
        defaultValue: DataTypes.NOW,
      },
      form_close_date: {
        type: DataTypes.DATE,
        defaultValue: DataTypes.NOW,
      },
      college_desc: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      college_facilities: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      college_email: {
        type: DataTypes.STRING(500),
        defaultValue: "",
      },
      college_contact: {
        type: DataTypes.STRING(500),
        defaultValue: "",
      },
      collage_meta_desc: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      collage_meta_char: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      collage_page_title: {
        type: DataTypes.TEXT,
        defaultValue: "",
      },
      estd_year: {
        type: DataTypes.STRING(250),
        defaultValue: "",
      },
      organization_type: {
        type: DataTypes.STRING(250),
        defaultValue: "",
      },
      is_featured: {
        type: DataTypes.TINYINT,
        defaultValue: 0,
      },
      is_silver: {
        type: DataTypes.TINYINT,
        defaultValue: 0,
      },
      is_gold: {
        type: DataTypes.TINYINT,
        defaultValue: 0,
      },
      is_platinum: {
        type: DataTypes.TINYINT,
        defaultValue: 0,
      },
      is_published: {
        type: DataTypes.TINYINT,
        defaultValue: 0,
      },
      is_approved: {
        type: DataTypes.TINYINT,
        defaultValue: 0,
      },
      college_dor: {
        type: DataTypes.DATE,
        defaultValue: DataTypes.NOW,
      },
    },
    {
      tableName: "tbl_college",
      timestamps: false,
      freezeTableName: true,
    }
  );

  College.associate = function (models) {
    College.hasOne(models.CollegeComparison, {
      foreignKey: "fk_college_id",
      as: "comparisonData",
    });

    College.hasMany(models.CollegeCourse, {
      foreignKey: "fk_college_id", // Must match the name in CollegeCourse model
      sourceKey: "college_id", // Must match the primary key in College model
      as: "courses",
    });
  };  

  return College;
};
