module.exports = (sequelize, DataTypes) => {
  const LandingPage = sequelize.define(
    "LandingPage",
    {
      college_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      college_url: {
        type: DataTypes.STRING(255),
      },
      college_logo: {
        type: DataTypes.STRING(255),
      },
      college_banner: {
        type: DataTypes.STRING(255),
      },
      title_1: {
        type: DataTypes.STRING(255),
      },
      description_1: {
        type: DataTypes.TEXT("long"),
      },
      title_2: {
        type: DataTypes.STRING(255),
      },
      description_2: {
        type: DataTypes.TEXT("long"),
      },
      companies: {
        type: DataTypes.TEXT,
        get() {
          const rawValue = this.getDataValue("companies");
          if (!rawValue) return [];

          try {
            return JSON.parse(rawValue);
          } catch (e) {
            console.error("Error parsing companies JSON:", e);
            return [];
          }
        },
        set(value) {
          if (Array.isArray(value)) {
            this.setDataValue("companies", JSON.stringify(value));
          } else if (typeof value === "string") {
            // Try to parse it first to validate
            try {
              JSON.parse(value);
              this.setDataValue("companies", value);
            } catch (e) {
              console.error("Invalid companies JSON string:", e);
              this.setDataValue("companies", "[]");
            }
          } else {
            this.setDataValue("companies", "[]");
          }
        },
      },
    },
    {
      tableName: "landing_pages",
      timestamps: false,
      underscored: true,
    }
  );

  LandingPage.associate = (models) => {
    LandingPage.belongsTo(models.College, {
      foreignKey: "college_id",
      as: "landingPageCollege",
    });
  };

  return LandingPage;
};
