module.exports = (sequelize, DataTypes) => {
  const CollegeComparison = sequelize.define(
    "tbl_college_comparison",
    {
      comparison_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      placements: DataTypes.STRING(250),
      highest_package: DataTypes.STRING(250),
      average_package: DataTypes.STRING(250),
      lowest_package: DataTypes.STRING(250),
      accreditation: DataTypes.TEXT,
      affiliation: DataTypes.TEXT,
      infrascructure: DataTypes.TEXT,
      ratings: DataTypes.DOUBLE,
      fk_college_id: DataTypes.INTEGER,
    },
    {
      tableName: "tbl_college_comparison",
      timestamps: false,
    }
  );

  CollegeComparison.associate = (models) => {
    CollegeComparison.belongsTo(models.College, {
      foreignKey: "fk_college_id",
      as: "college",
    });
  };

  return CollegeComparison;
};
