module.exports = (sequelize, DataTypes) => {
  const PPStoryData = sequelize.define(
    "PPStoryData",
    {
      ppsdId: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
        field: "ppsd_id",
      },
      fkPpsId: {
        type: DataTypes.INTEGER,
        field: "fk_pps_id",
      },
      ppsdOrder: {
        type: DataTypes.INTEGER,
        field: "ppsd_order",
      },
      ppsdTitle: {
        type: DataTypes.TEXT,
        field: "ppsd_title",
      },
      ppsdDescription: {
        type: DataTypes.TEXT,
        field: "ppsd_description",
      },
      ppsdValue: {
        type: DataTypes.TEXT,
        field: "ppsd_value",
      },
    },
    {
      tableName: "pp_story_data",
      timestamps: false,
      underscored: true,
    }
  );

  PPStoryData.associate = function (models) {
    PPStoryData.belongsTo(models.PPStory, {
      foreignKey: "fk_pps_id",
      as: "story",
    });
  };

  return PPStoryData;
};
