module.exports = (sequelize, DataTypes) => {
  const BlogCategory = sequelize.define(
    "BlogCategory",
    {
      ppc_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      ppc_title: {
        type: DataTypes.STRING,
        allowNull: false,
        validate: {
          notEmpty: true,
        },
      },
      ppc_description: {
        type: DataTypes.TEXT,
        allowNull: true,
        defaultValue: "",
      },
      ppc_satus: {
        type: DataTypes.TINYINT,
        defaultValue: 1,
      },
      ppc_created_date: {
        type: DataTypes.DATE,
        defaultValue: DataTypes.NOW,
      },
    },
    {
      tableName: "pp_category",
      timestamps: false,
      underscored: true,
    }
  );
  return BlogCategory;
};
