const db = require("../../db");

exports.getBlogComments = async (req, res) => {
  try {
    const { id } = req.query;

    if (id) {
      const comment = await db.BlogComments.findByPk(id);
      if (!comment) {
        return res.status(404).json({ error: "Comment not found" });
      }
      res.json(comment);
    }

    const comments = await db.BlogComments.findAll();
    res.json(comments);
  } catch (err) {
    console.error("Error fetching blog comments:", err);
    res.status(500).json({ error: "Failed to fetch blog comments" });
  }
};
