// routes/collegeComparisonRoutes.js
const express = require("express");
const router = express.Router();
const collegeComparisonController = require("../controllers/collegeComparisonController");

// Create college comparison data
router.post("/", collegeComparisonController.createComparison);

// Compare two colleges
router.get(
  "/compare/:college1Id/:college2Id",
  collegeComparisonController.compareColleges
);

// Get single comparison data
router.get("/:id", collegeComparisonController.getComparisonById);

// Update comparison data
router.put("/:id", collegeComparisonController.updateComparison);

// Delete comparison data
router.delete("/:id", collegeComparisonController.deleteComparison);

module.exports = router;
