const express = require("express");
const router = express.Router();
const ppStoryController = require("../../controllers/blog/ppStoryController");

// Create a new story
router.post("/", ppStoryController.createStory);

router.get("/", ppStoryController.getAllStories);
router.get("/images/:filename", ppStoryController.getStoryImage);

// Get a story with all its data
router.get("/:id", ppStoryController.getStoryWithData);

// Add data to a story
router.post("/:id/data", ppStoryController.addStoryData);

// Update a story
router.put("/:id", ppStoryController.updateStory);

// Delete a story
router.delete("/:id", ppStoryController.deleteStory);

module.exports = router;
