const express = require("express");
const router = express.Router();
const db = require("../../models");
const blogController = require("../../controllers/blog/blogController");

router.post("/", blogController.createBlog);

router.get("/", blogController.getBlog);
router.get("/categories", blogController.getCategories);

router.get("/categories", blogController.getCategories);

router.put("/:id", blogController.putBlog);

router.delete("/:id", blogController.deleteBlog);

module.exports = router;
