module.exports = (sequelize, DataTypes) => {
  const Company = sequelize.define(
    "Company",
    {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      company: {
        type: DataTypes.STRING(250),
        allowNull: false,
      },
      image: {
        type: DataTypes.STRING(255),
      },
      status: {
        type: DataTypes.INTEGER,
        defaultValue: 1,
      },
    },
    {
      tableName: "lp_companies", // Match your actual table name
      timestamps: false, // Disable automatic timestamp fields
      underscored: false, // Disable automatic column name transformation
    }
  );
  return Company;
};
