// models/collegeComparisonModel.js
module.exports = (sequelize, DataTypes) => {
  const CollegeComparison = sequelize.define(
    "CollegeComparison",
    {
      comparison_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      placements: {
        type: DataTypes.STRING(250),
        allowNull: true,
      },
      highest_package: {
        type: DataTypes.STRING(250),
        allowNull: true,
      },
      lowest_package: {
        type: DataTypes.STRING(250),
        allowNull: true,
      },
      average_package: {
        type: DataTypes.STRING(250),
        allowNull: true,
      },
      year_estd: {
        type: DataTypes.STRING(250),
        allowNull: true,
      },
      accreditation: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      affiliation: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      approval: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      recognition: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      ranking: {
        type: DataTypes.DOUBLE,
        allowNull: true,
      },
      fees_course: {
        type: DataTypes.STRING(251),
        allowNull: true,
      },
      form_price: {
        type: DataTypes.STRING(250),
        allowNull: true,
      },
      ratings: {
        type: DataTypes.DOUBLE,
        allowNull: true,
      },
      intake: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      eligibility_criteria: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      CAT: {
        type: DataTypes.STRING(250),
        field: "CAT", // Explicitly set the column name
      },
      CMAT: {
        type: DataTypes.STRING(250),
        field: "CMAT",
      },
      GMAT: {
        type: DataTypes.STRING(250),
        field: "GMAT",
      },
      MAT: {
        type: DataTypes.STRING(250),
        field: "MAT",
      },
      ATMA: {
        type: DataTypes.STRING(250),
        field: "ATMA",
      },
      industry_interface: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      infrastructure: {
        type: DataTypes.TEXT,
        field: "infrascructure",
        allowNull: true,
      },
      hotel: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      mess: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      library: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      internet: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      certification: {
        type: DataTypes.TEXT,
        field: "cretification",
        allowNull: true,
      },
      additional_benefits: {
        type: DataTypes.TEXT,
        field: "additional_benifites",
        allowNull: true,
      },
      fk_college_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
          model: "Colleges", // Assuming you have a College model
          key: "id",
        },
      },
    },
    {
      tableName: "tbl_college_comparison",
      timestamps: false,
      underscored: false,
      freezeTableName: true,
    }
  );

  // Define association
  CollegeComparison.associate = function (models) {
    CollegeComparison.belongsTo(models.College, {
      foreignKey: "fk_college_id",
      as: "college",
    });
  };

  return CollegeComparison;
};
