module.exports = (sequelize, DataTypes) => {
  const PPStory = sequelize.define(
    "PPStory",
    {
      pps_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      pps_title: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      pps_author: {
        type: DataTypes.STRING(40),
      },
      ppsDescription: {
        type: DataTypes.TEXT, // Changed from BLOB to TEXT
        field: "pps_desctiption",
        get() {
          const rawValue = this.getDataValue("ppsDescription");
          return rawValue ? rawValue.toString("utf8") : null;
        },
      },
      ppsShortLink: {
        type: DataTypes.TEXT,
        field: "pps_short_link",
      },
      ppsTags: {
        type: DataTypes.TEXT,
        field: "pps_tags",
      },
      ppsGenre: {
        type: DataTypes.TEXT,
        field: "pps_genre",
      },
      ppsCategory: {
        type: DataTypes.TEXT,
        field: "pps_category",
      },
      ppsCoverImage1: {
        type: DataTypes.TEXT,
        field: "pps_cover_image1",
      },
      ppsCoverImage2: {
        type: DataTypes.TEXT,
        field: "pps_cover_image2",
      },
      ppsCoverImage3: {
        type: DataTypes.TEXT,
        field: "pps_cover_image3",
      },
      ppsCoverImage4: {
        type: DataTypes.TEXT,
        field: "pps_cover_image4",
      },
      ppsCoverImage5: {
        type: DataTypes.TEXT,
        field: "pps_cover_image5",
      },
      ppsViews: {
        type: DataTypes.STRING(250),
        field: "pps_views",
      },
      ppsStatus: {
        type: DataTypes.TINYINT,
        field: "pps_status",
      },
      ppsMetaKeywords: {
        type: DataTypes.TEXT,
        field: "pps_meta_keywords",
      },
      ppsMetaDescriptions: {
        type: DataTypes.TEXT,
        field: "pps_meta_descriptions",
      },
      ppsDateUpdated: {
        type: DataTypes.DATE,
        field: "pps_date_updated",
      },
      ppsDateCreated: {
        type: DataTypes.DATE,
        field: "pps_date_created",
      },
    },
    {
      tableName: "pp_story",
      timestamps: false,
      underscored: true,
    }
  );

  PPStory.associate = function (models) {
    PPStory.hasMany(models.PPStoryData, {
      foreignKey: "fk_pps_id",
      as: "storyData",
    });
  };

  return PPStory;
};
